#ifndef MADAH_GAME_H_
#define MADAH_GAME_H_

#include <vector>

#include <SDL.h>

// #include <audiere.h>

#include "gamefont.h"

#include "map.h"
#include "viewport.h"

const int MAX_KEYSTATES			= SDLK_LAST;
const int MAX_MOUSESTATES		= 4;

const int STATE_SCREEN_GAME		= 1;
const int STATE_SCREEN_HELP		= 2;
const int STATE_SCREEN_MENU		= 3;

const int MAX_MOUSE_TILES	=	3;

const static char *game_copyright = "MaDah's Build The Level You Play! 1.00 (c) 2007 MaDah";

struct mousestate_t
{
	int  button;
	bool moved;
	bool mbdown;
	bool mbpressed;
	int  x,y;
};

struct moving_tile_t
{
	bool active;
	int x1,y1,x2,y2;
	SDL_Surface *bmp;
};

// forward:
class Player; 



class Game
{
friend class Player;
private:

	GameFont * font;

	bool should_quit;
	int screen_state;

	int framecounter;
	bool game_isdone;

	bool keydown[MAX_KEYSTATES];
	bool keypressed[MAX_KEYSTATES];
	mousestate_t mousestate[MAX_MOUSESTATES];

	void InitStates();
	void ResetStates();

	Map	map;
	Viewport viewport;

	int mouse_tile;
	int mouse_tiles[MAX_MOUSE_TILES];
	int mouse_tile_anim_countdown, mouse_tile_anim_countmax;

	std::vector<int> random_tiles;

	int current_level, placed_tiles, coins_left;
	int last_player_count;

	char msg[256];
	float message_delay;
	bool level_completed;
	float level_completed_delay;
	bool game_over;
	float game_over_delay;

	int anim;
	float anim_delay, anim_delay_max;
	moving_tile_t	moving_tile;

	int menu_selected;

	// Draw screen:
	void Draw_Game		(SDL_Surface *screen, const float alpha);
	void Draw_Menu		(SDL_Surface *screen, const float alpha);
	void Draw_Help		(SDL_Surface *screen, const float alpha);

	// Update Game logic:
	void Update_Game	(const float dt);
	void Update_Menu	(const float dt);
	void Update_Help	(const float dt);

	void GenerateAllMouseTiles();
	void GenerateNewMouseTiles();

	void InitRandomTiles();

public:
	
	bool ShouldQuit()	{	return should_quit;	}

	// Redraw entire screen:
	void Draw(SDL_Surface *screen, const float alpha);

	// Update game logic:
	void Update(const float dt);

	void InitNewGame();

	// Input handling:  SDLinput -> game wrapper
	void KeyDown		(SDL_keysym *key);
	void KeyUp			(SDL_keysym *key);
	void MouseMove		(SDL_MouseMotionEvent *motion);
	void MouseDown		(SDL_MouseButtonEvent *button);
	void MouseUp		(SDL_MouseButtonEvent *button);

	// constructor/destructor
	Game();
	~Game();
};

#endif
