#ifndef MADAH_GAME_FONT_H
#define MADAH_GAME_FONT_H

#include <SDL.h>

class GameFont
{
private:

	SDL_Surface *font;
	int charwidth,charheight, chars_row, charkerning;

public:

	void PrintText(SDL_Surface *dst, int dstx, int dsty, const char *s)
	{
		if( s == NULL ) return;

		SDL_Rect dstrect, srcrect;

		int x=dstx;
		int y=dsty;

        while( *s )
		{
			switch( *s )
			{
			case '\n':
				x=dstx;
				y += charheight;
				break;
			default:
				{
					unsigned int c = *s;
					if( c > 32 )
					{
						c -= 32;
						srcrect.w	= (Uint16)charwidth;
						srcrect.h	= (Uint16)charheight;
						srcrect.x	= (Sint16)(charwidth  * (int)((c) % (unsigned int)chars_row));
						srcrect.y	= (Sint16)(charheight * (int)((c) / (unsigned int)chars_row));

						dstrect.x = (Sint16)x;
						dstrect.y = (Sint16)y;
						SDL_BlitSurface( font, &srcrect, dst, &dstrect );

					}
					x += charkerning;
				}
			}
			s++;
		}
	}	

	void SetSDLSurface( SDL_Surface *s)
	{
		if(font)	SDL_FreeSurface(font);
		font = s;
	}

	void SetKerning(int k)
	{
		charkerning = k;
	}

	void SetCharWidthHeight(int w, int h)
	{
		charwidth	= w;
		charheight	= h;
		charkerning	= w;
		chars_row	= 0;
		if(font)
		{
			chars_row = font->w / charwidth;	
		}
	}	

	GameFont()
		: font(NULL), charwidth(0), charheight(0), chars_row(0), charkerning(0)
	{
	}

	~GameFont()
	{
		if(font)
		{
			SDL_FreeSurface(font);
			font = NULL;
		}
	}

};


#endif
