#include <SDL.h>
// #include <SDL_image.h>

#include <physfs.h>
#include <extras/physfsrwops.h>

#include "gfx.h"

// global class because of laziness:
Gfx GFX;

// Load image using physfs and converts into correct displayformat
SDL_Surface * LoadImage(const char *filename, const bool colorkey, const Uint32 key)
 {
	SDL_Surface *s = NULL;
	SDL_RWops *rw = PHYSFSRWOPS_openRead( filename );
	if( rw )
	{
		s = SDL_LoadBMP_RW(rw,0);
			//IMG_Load_RW(rw,0);	// Use SDL_image
		if(s)
		{
			if(colorkey)	SDL_SetColorKey(s, SDL_SRCCOLORKEY|SDL_RLEACCEL, key);
			SDL_Surface *temp = SDL_DisplayFormat(s);
			if(temp)
			{
				SDL_FreeSurface(s);
				s = temp;
			}
		}
		SDL_FreeRW(rw);
	}
	return s;
}

void LoadBitmapArray( SDL_Surface **bmp, const char *basedir, const char *basename, int count)
{
	char buf[256];

	for(int i=0; i<count; ++i)
	{
		sprintf(buf, "%s%s%.4d.bmp", basedir, basename, i);
		bmp[i] = LoadImage(buf, true, 0xFF00FF);
	}
}

void Gfx :: LoadBitmaps()
{
	const char * basedir = "gamedata/gfx/";

	LoadBitmapArray( tiles,		basedir, "tiles", 8 );
	LoadBitmapArray( player,	basedir, "player", 10 );
	LoadBitmapArray( stones,	basedir, "stone", 2 );
	LoadBitmapArray( mouse,		basedir, "mouse", 2 );
	LoadBitmapArray( ladder,	basedir, "ladder", 1 );
	LoadBitmapArray( coin,		basedir, "coins", 1 );
	LoadBitmapArray( skull,		basedir, "skull", 1 );
	LoadBitmapArray( selection,	basedir, "selection", 2 );
	LoadBitmapArray( stars,		basedir, "stars", 8 );
	LoadBitmapArray( monster,	basedir, "monster", 8 );

}
