#ifndef MADAH_GAME_GFX_H_
#define MADAH_GAME_GFX_H_

#include <cstring>

#include <SDL.h>

#include "gamefont.h"

class Gfx
{
public:

	GameFont * font;
	
	SDL_Surface * tiles[8];
	SDL_Surface * player[10];

	SDL_Surface * stones[8];

	SDL_Surface * mouse[4];
	SDL_Surface * ladder[1];
	SDL_Surface * coin[1];
	SDL_Surface * skull[1];
	SDL_Surface * selection[2];
	SDL_Surface * stars[4];
	SDL_Surface * monster[8];

	void LoadBitmaps();

	Gfx()
		: font(NULL)
	{
		memset( tiles, 0, sizeof(tiles) );
		memset( player, 0, sizeof(player) );
		memset( stones, 0, sizeof(stones) );
		memset( mouse, 0, sizeof(mouse) );
		memset( ladder, 0, sizeof(ladder) );
		memset( coin, 0, sizeof(coin) );
		memset( skull, 0, sizeof(skull) );
		memset( selection, 0, sizeof(selection) );
		memset( stars, 0, sizeof(stars) );
		memset( monster, 0, sizeof(monster) );

	}
};


extern Gfx GFX;

// Load image using physfs and converts into correct displayformat
SDL_Surface * LoadImage(const char *filename, const bool colorkey, const Uint32 key);


#endif
