#ifndef MADAH_GAME_MAP_H_
#define MADAH_GAME_MAP_H_

#include <SDL.h>

// forward:
class ObjectManager;
class Viewport;


class TileTypes
{
public:
	enum
	{
		None = 0,

		Invalid,
		Outside,
		Border,
		Open,
		Wall,
		Ladder,
		Skull,
		OneWay_Left,
		OneWay_Right,
		Teleport,

		Special_AddPlayer,
		Special_AddEnemy,
		Special_Bomb,
		Special_Coin,

		Last
	};
};


struct maptile_t
{
	int tile;
};

class Map
{
friend class Game;
private:

	int width, height;
	maptile_t * tiles;

	ObjectManager	* objmanager;

public:

	bool GetTeleportDestination( int *xp, int *yp );

	SDL_Surface *GetTileBMP( int tiletype );

	void AllocateMap(int w, int h);
	int GetTileTypeAt(int x, int y);

	void PasteTileAt(int x, int y, int tile);

	void ExplosionAt(int x, int y,int radius);

	void Update(const float dt);
	void UpdateAnims(const float dt);
	void Draw(Viewport *viewport, const float alpha);

	void InitNewGame(int level, int player_count);

	Map();
	~Map();

};



#endif
