#ifndef MADAH_GAME_OBJECT_H_
#define MADAH_GAME_OBJECT_H_

#include <SDL.h>

// forward:
class ObjectManager;

class ObjectTypes
{
public:
	enum
	{
		None = 0,
		Player,
		Monster,
		Enemy,
		Item,
		Coin,
		Key,

		Last
	};
};


// virtual base class:
class Object
{
friend class ObjectManager;
protected:
	int type;
	int x,y;
	int direction;
	int state;

	bool delete_me;

	ObjectManager	*parent;

public:

	virtual int GetType() = 0;
	virtual int GetSubType()
	{
		return 0;
	}

	virtual void Death()
	{
	}

	void CheckCollision( Object * other )
	{
		if( (x == other->x) && (y == other->y ) )
		{
			CollisionWith( other );
			other->CollisionWith( this );
		}
	}

	virtual void CollisionWith( Object * other )
	{
	}

	virtual void Update(const float dt) = 0;
	virtual void UpdateAnims(const float dt) = 0;
	virtual void Draw(Viewport *viewport, const float alpha) = 0;	

	Object()
		:	type(0),x(0),y(0),direction(0),state(0),delete_me(false),parent(NULL) 
	{
	}

	virtual ~Object()
	{
	}
};



#endif
