#ifndef MADAH_GAME_OBJECT_ITEM_H_
#define MADAH_GAME_OBJECT_ITEM_H_

// forward:
class Object;
class Viewport;


class ItemTypes
{
public:
	enum
	{
		None = 0,
		Life,
		Keys,
		Coins,
		Score,
		Bomb,

		Last
	};
};


class ObjectItem : public Object
{
friend class Map;
friend class Game;
private:
	float anim_delay, anim_delay_max;
	int oldx, oldy, anim;
	int life, keys, coins, score;
	int update_counter, update_counter_max;
	int itemtype;
	int timeout_counter;
	float timeout_delay;
public:

	void Death();

	int GetType()
	{
		return ObjectTypes::Item;
	}

	int GetSubType()
	{
		return itemtype;
	}

	void CollisionWith( Object * other );

	void Update(const float dt);
	void UpdateAnims(const float dt);
	void Draw(Viewport *viewport, const float alpha);	

	ObjectItem();
	~ObjectItem();

};



#endif
