#ifndef MADAH_GAME_OBJECT_MANAGER_H_
#define MADAH_GAME_OBJECT_MANAGER_H_

#include <list>

#include <SDL.h>

// forward:
class Object;
class Map;
class Viewport;


typedef std::list<Object *>	object_list_t;

class ObjectManager
{
friend class Map;
private:
	object_list_t	list;

	Object * main_object;

	Map *map;

public:

	Object * GetMainObject()	{	return main_object;	}

	Object * FindObject(int type);

	int GetObjectTypeCount(int type);
	int GetObjectSubTypeCount(int type, int subtype);

	void ExplosionAt(int x, int y,int radius);

	Map *GetMap()	{	return map;	}

	void Clear();
	void LinkObject( Object *obj );

	void Update(const float dt);
	void UpdateAnims(const float dt);
	void Draw(Viewport *viewport, const float alpha);

	ObjectManager(Map *owner);
	~ObjectManager();
};




#endif
