#ifndef MADAH_GAME_OBJECT_MONSTER_H_
#define MADAH_GAME_OBJECT_MONSTER_H_

// forward:
class Object;
class Viewport;
class ObjectItem;
class Game;


class Monster : public Object
{
friend class Game;
friend class Map;
friend class ObjectItem;
private:
	float anim_delay, anim_delay_max;
	int oldx, oldy, anim, falling_count;
	int life, keys, coins, score;
	int update_counter, update_counter_max, 
		walk_speed;
	int last_teleport_x, last_teleport_y, last_teleport_counter;

public:

	int GetType()
	{
		return ObjectTypes::Monster;
	}

	void Death();
	void CollisionWith( Object * other );

	void Update(const float dt);
	void UpdateAnims(const float dt);
	void Draw(Viewport *viewport, const float alpha);	

	Monster();
	~Monster();

};



#endif
