#include <physfs.h>

#include <audiere.h>

#include "snd.h"

// global sound class:
Snd SND;

// Load sound for Audiere from PhysFS calls:

// allocate and load entire file at once:
audiere::OutputStreamPtr LoadSound(audiere::AudioDevicePtr device, const char *filename )
{
	audiere::OutputStreamPtr	result = NULL;

	PHYSFS_file *handle = PHYSFS_openRead(filename);
	
	if( handle )
	{
		void * buffer = NULL;
		int filesize = (int)PHYSFS_fileLength( handle );
		int ret = 0;
		if( filesize >0 )
		{
			buffer = (void *)malloc( filesize );
			if( buffer )
			{
				ret = (int)PHYSFS_read( handle, buffer, 1, filesize );
			}
		}
		PHYSFS_close(handle);

		if( ret >0 )
		{
			audiere::File* f = audiere::CreateMemoryFile( buffer, ret );
			result = audiere::OpenSound( device, f, true );
			f = NULL;
		}

		if( buffer ) 
		{
			memset( buffer, 0, filesize );
			free(buffer);
		}
	}

	return result;
}

audiere::SoundEffectPtr LoadSoundFX(audiere::AudioDevicePtr device, const char *filename )
{
	audiere::SoundEffectPtr	result = NULL;

	PHYSFS_file *handle = PHYSFS_openRead(filename);
	
	if( handle )
	{
		void * buffer = NULL;
		int filesize = (int)PHYSFS_fileLength( handle );
		int ret = 0;
		if( filesize >0 )
		{
			buffer = (void *)malloc( filesize );
			if( buffer )
			{
				ret = (int)PHYSFS_read( handle, buffer, 1, filesize );
			}
		}
		PHYSFS_close(handle);

		if( ret >0 )
		{
			audiere::File* f = audiere::CreateMemoryFile( buffer, ret );
			result = audiere::OpenSoundEffect( device, f, audiere::MULTIPLE );
			f = NULL;
		}

		if( buffer ) 
		{
			free(buffer);
		}
	}

	return result;
}

void Snd :: OpenDevice()
{
	device = audiere::OpenDevice();
}

void Snd :: LoadSounds()
{
	const char *basedir = "gamedata/snd/";
	char buf[256];

	for(int i=0; i<2; ++i)
	{
		sprintf(buf, "%smusic%.2d.ogg", basedir, i);
		music[i] = LoadSound( device, buf );
	}

	for(int i=0; i<16; ++i)
	{
		sprintf(buf, "%ssfx%.4d.ogg", basedir, i);
		sound[i] = LoadSoundFX( device, buf );
	}
}

