#ifndef MADAH_GAME_SND_H_
#define MADAH_GAME_SND_H_

#include <audiere.h>

class Snd
{
public:
	audiere::AudioDevicePtr		device;

	audiere::OutputStreamPtr	music[2];

	audiere::SoundEffectPtr		sound[16];

	void OpenDevice();
	void LoadSounds();

	Snd()	
		:	device(0)
	{
		for(int i=0; i<2; ++i)
		{
			music[i] = 0;
		}
		for(int i=0; i<16; ++i)
		{
			sound[i] = 0;
		}
	}

	~Snd()
	{
		for(int i=0; i<2; ++i)
		{
			if( music[i] ) music[i]->stop();
			music[i] = 0;
		}
		for(int i=0; i<16; ++i)
		{
			if( sound[i] ) sound[i]->stop();
			sound[i] = 0;
		}

		device	= 0;
	}

};

// global sound class:
extern Snd SND;

#endif
