#include <stdio.h>
#include <io.h>
#include <time.h>
#include <limits.h>

#include <tchar.h>

#define WIN32_LEAN_AND_MEAN

#include <windows.h>

#include <shlobj.h>
#include <shellapi.h>
#include <commctrl.h>
#include <shellapi.h>

#define APP_VERSION_STR "FolderDate 0.01 (c) 2006 MaDah"

#define ID_BUTTON_BROWSE_FOLDER		500
#define ID_BUTTON_DOIT				501


typedef struct 
{
	HWND	hwnd;
	
	HWND	hwndLblFolder;
	HWND	hwndTxtFolder;
	HWND	hwndCmdFolder;
	HWND	hwndCmdDoIt;
	
	bool silent, autostart;
	
	const _TCHAR * path_arg;
	
	int folders_changed, folders_total;
	
} mainwindow_t;

//  Global variable:
mainwindow_t mainwindow;


FILETIME GetNewest(FILETIME *T1, FILETIME *T2)
{
	if( T1->dwHighDateTime > T2->dwHighDateTime )
	{
		return *T1;
	} 
	else if( T1->dwHighDateTime < T2->dwHighDateTime )
	{
		return *T2;
	} 
	else 
	{
		if( T1->dwLowDateTime > T2->dwLowDateTime )
		{
			return *T1;
		} 
		else if( T1->dwLowDateTime < T2->dwLowDateTime )
		{
			return *T2;
		} 
		else
		{
			// Equal
			return *T1;
		}
	}
}

FILETIME AddFilesFromPathRecursive(_TCHAR * fullpath, _TCHAR * current_ptr, const _TCHAR * rel_path_)
{
	WIN32_FIND_DATA fileinfo;
	HANDLE handle;

	FILETIME time1,time2;
	
	size_t path_len = _tcslen(rel_path_);
	_TCHAR * path_ptr;

	time1.dwLowDateTime   = 0;
	time1.dwHighDateTime  = 0;		

	memcpy( current_ptr, rel_path_, path_len * sizeof(_TCHAR) );
	path_ptr = &current_ptr[path_len-1];

	if( *path_ptr != _T('\\') )
	{
		++path_ptr;
		*path_ptr = _T('\\');
	}

	++path_ptr;
	path_ptr[0] = _T('*');
	path_ptr[1] = _T('\0');
	
	handle = FindFirstFile(fullpath, &fileinfo);

	path_ptr[0] = _T('\0');

	current_ptr = path_ptr;
	
	if( handle != INVALID_HANDLE_VALUE )
	{
		do
		{
			if( (fileinfo.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0  )			
			{
				if( (_tcscmp(fileinfo.cFileName, _T(".")) != 0) && 
					(_tcscmp(fileinfo.cFileName, _T("..")) != 0) )
				{
					mainwindow.folders_total++;
					time2 = AddFilesFromPathRecursive( fullpath, current_ptr, fileinfo.cFileName );
					
					if( (time2.dwLowDateTime!=0) || (time2.dwHighDateTime!=0) )
					{
						_tcscpy( current_ptr, fileinfo.cFileName );
						
						HANDLE fh = CreateFile( fullpath, GENERIC_WRITE, FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_FLAG_BACKUP_SEMANTICS,0);
						if( fh != INVALID_HANDLE_VALUE )
						{
							if( SetFileTime(fh,NULL,NULL, &time2) )
							{
								mainwindow.folders_changed++;
							}
							CloseHandle(fh);
						}
					}

					time1 = GetNewest( &time1, &time2 );					
				}
			}
		} 
		while( FindNextFile(handle, &fileinfo) == TRUE );
		FindClose( handle );	
	}


	{
		path_ptr[0] = _T('*');
		path_ptr[1] = _T('\0');
				
		handle = FindFirstFile(fullpath, &fileinfo);
		path_ptr[0] = _T('\0');

		if( handle != INVALID_HANDLE_VALUE )
		{
			do
			{
				if( (fileinfo.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == 0  )			
				{
					time1 = GetNewest( &time1, &fileinfo.ftLastWriteTime );					
				}
			} 
			while( FindNextFile(handle, &fileinfo) == TRUE );
			FindClose( handle );	
		}
	}

	return time1;
}


void process_folder(const _TCHAR *path)
{
	if( path == NULL ) return;
	if( (*path) == _T('\0') ) return;
	
	size_t path_len = _tcslen( path );
	if( path_len >= (32*1024-256) ) return;
	
	_TCHAR fullpath[32*1024] = {0};

	mainwindow.folders_changed = 0;
	mainwindow.folders_total   = 0;
	
	AddFilesFromPathRecursive( fullpath, fullpath, path );


}

bool BrowseForFolder(HWND owner, _TCHAR *dest)
{
	bool result = false;

	BROWSEINFO browseinfo;
	ITEMIDLIST *itemidlist = NULL;

	if( dest == NULL ) return false;
	
	(*dest) = (_TCHAR)'\0';

	memset(&browseinfo,0,sizeof(BROWSEINFO));
	browseinfo.hwndOwner		= owner;
	browseinfo.pszDisplayName	= dest;
	browseinfo.ulFlags			= BIF_RETURNONLYFSDIRS | BIF_USENEWUI | BIF_NEWDIALOGSTYLE;
	
	if( (itemidlist = SHBrowseForFolder( &browseinfo )) != NULL )
	{
		if( SHGetPathFromIDList( itemidlist, dest ) )
		{
			result = true;
		}
		
        // free memory used
        IMalloc * imalloc = NULL;
        if ( SUCCEEDED( SHGetMalloc ( &imalloc )) )
        {
            imalloc->Free ( itemidlist );
            imalloc->Release ( );
        }		
		//CoTaskMemFree( itemidlist );
	}
	return result;
}


_TCHAR * get_textbox(const HWND hwnd, size_t * len)
{
	(*len) = 0;
	WORD bufferlen = (WORD)SendMessage(hwnd,		EM_LINELENGTH, 0, 0);
	if(bufferlen == 0)	return NULL;

	_TCHAR * text = (_TCHAR *)calloc(bufferlen+1,sizeof(_TCHAR));
	memcpy(text,&bufferlen,sizeof(bufferlen));

	if(SendMessage(hwnd,	EM_GETLINE, 0, (LPARAM)text) == 0)
	{
		if(text)	free(text);
		return NULL;
	}
	(*len) = bufferlen;
	return text;
}


void EnableControls(const BOOL b)
{
	EnableWindow( mainwindow.hwndLblFolder,				b );
	EnableWindow( mainwindow.hwndTxtFolder,				b );
	EnableWindow( mainwindow.hwndCmdFolder,				b );
	EnableWindow( mainwindow.hwndCmdDoIt,				b );
}

// Step 4: the Window Procedure
LRESULT CALLBACK WndOptionsProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;

	switch(msg)
	{
		
	case WM_COMMAND:
		wmId    = LOWORD(wParam); 
		wmEvent = HIWORD(wParam); 
			switch(wmEvent)
			{				
				case BN_CLICKED:
					switch( wmId )
					{
					case ID_BUTTON_BROWSE_FOLDER:
						{
							_TCHAR buffer[4*1024 + MAX_PATH+1] = {0};
							if( BrowseForFolder( mainwindow.hwnd, buffer ) )
							{
								SendMessage( mainwindow.hwndTxtFolder, WM_SETTEXT,0, (LPARAM)buffer);
							}
						}
						break;
						
					case ID_BUTTON_DOIT:
						{
							size_t len = 0;
							_TCHAR * s = get_textbox( mainwindow.hwndTxtFolder, &len);
							if( s )
							{
								EnableControls( FALSE );
								process_folder( s );
								free( s );
								
								if( mainwindow.silent == false )
								{	
									_TCHAR buffer[1*1024];
									_stprintf(buffer, _T("Folder dates changed: %d out of %d"), mainwindow.folders_changed, mainwindow.folders_total );
									MessageBox( mainwindow.hwnd, buffer, _T("Done!"), MB_OK | MB_ICONINFORMATION );
								}								
								
								EnableControls( TRUE );
							}							
						}
						break;
						
					default:
						return DefWindowProc(hwnd, msg, wParam, lParam);
					}
			default:
				return DefWindowProc(hwnd, msg, wParam, lParam);
			}
			break;
	case WM_CLOSE:
		DestroyWindow(hwnd);
		break;						
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hwnd, msg, wParam, lParam);
	}
	return 0;
}

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{

	//INITCOMMONCONTROLSEX icex;
	memset(&mainwindow,0,sizeof(mainwindow_t));
	
	// Check args
	{
	
		const int max_arg = 1024;
		int argc = 1;
		_TCHAR * argv[max_arg] = {0};
			
		{
			_TCHAR * ptr = lpCmdLine;
			while( (*ptr) && ( argc < max_arg) )
			{
				// skip whitespace
				while( ((*ptr) == _T(' ')) || ((*ptr) == _T('\t')) ) ++ptr;	
				if( (*ptr) == 0 ) break;
				// check if quotation
				if( (*ptr) == _T('"') )
				{
					++ptr;
					argv[ argc++ ] = ptr;
					while( (*ptr) && ((*ptr) != _T('"')) ) ++ptr;	
					if( (*ptr) == 0 ) break;
					*ptr++ = 0;
				}
				else	// skip to whitespace
				{				
					argv[ argc++ ] = ptr;
					while( (*ptr) && ((*ptr) != _T(' ')) && ((*ptr) != _T('\t')) ) ++ptr;	
					if( (*ptr) == 0 ) break;
					*ptr++ = 0;				
				}
			}			
		}	
	
		{
			bool scanswitches=true;

			for(int i=1; i<argc; i++)
			{
				_TCHAR * s = argv[i];
				
				// Check switches:
				if( (scanswitches==true) && ( (*s) && (((*s)==_T('-')) || ((*s)==_T('/'))) ) )
				{
					++s;
					switch( *s )
					{
						case _T('s'):
						case _T('S'):
							mainwindow.silent = true;
							break;	
						
						case _T('a'):
						case _T('A'):
							mainwindow.autostart = true;
							break;							
						
						case _T('-'):
						case _T('/'):
							scanswitches = false;
							break;
					}
				}
				else
				{
					mainwindow.path_arg = s;
					if( mainwindow.autostart )
					{
						process_folder( s );
					}
				}			
			}
		}
	}
	
	if( mainwindow.autostart ) 
	{
		if( mainwindow.silent == false )
		{	
			_TCHAR buffer[1*1024];
			_stprintf(buffer, _T("Folder dates changed: %d out of %d"), mainwindow.folders_changed, mainwindow.folders_total );
			MessageBox( mainwindow.hwnd, buffer, _T("Done!"), MB_OK | MB_ICONINFORMATION );
		}	
		return 0;
	}
	
	
	const _TCHAR g_szClassName[] = _T("MadahFolderDateWin32Gui");
	WNDCLASSEX wc;
	
	//Step 1: Registering the Window Class
	memset(&wc,0,sizeof(WNDCLASSEX));
	wc.cbSize        = sizeof(WNDCLASSEX);
	wc.style         = 0;
	wc.lpfnWndProc   = WndOptionsProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = hInstance;
	wc.hIcon         = (HICON)LoadImage(hInstance, MAKEINTRESOURCE(1),IMAGE_ICON,0,0,LR_DEFAULTSIZE);
	wc.hIconSm		 = (HICON)LoadImage(hInstance, MAKEINTRESOURCE(1),IMAGE_ICON,
						GetSystemMetrics( SM_CXSMICON ), GetSystemMetrics( SM_CYSMICON ),0);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_BTNFACE+1); //(COLOR_BTNFACE);  //;
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = g_szClassName;

	if(!RegisterClassEx(&wc))
	{
		if( mainwindow.silent == false )
		{	
			MessageBox(NULL, _T("RegisterClassEx() failed"), _T("Error"),MB_ICONERROR | MB_OK);
		}
		return 1;
	}
	
	int window_width	= 384;
	int window_height	= 128;
	int window_x		= 0;
	int window_y		= 0;
	
	{
		int screenx = GetSystemMetrics(SM_CXSCREEN);
		int screeny = GetSystemMetrics(SM_CYSCREEN);
		{
			// center on screen
			window_x		= (screenx - window_width)/2;
			window_y		= (screeny - window_height)/2;
		}
	}
	
		// Step 2: Creating the Window
	mainwindow.hwnd =	
	CreateWindow(
		g_szClassName, 
		_T(APP_VERSION_STR),
		WS_OVERLAPPEDWINDOW-WS_MAXIMIZEBOX-WS_THICKFRAME,
        window_x, window_y, window_width, window_height, NULL, NULL, hInstance, NULL );
		
	if(mainwindow.hwnd == NULL)
	{
		if( mainwindow.silent == false )
		{
			MessageBox(NULL, _T("CreateWindow() failed"), _T("Error"),MB_ICONERROR | MB_OK);
		}
		return 1;
	}
	
	RECT rect;
	
	GetClientRect( mainwindow.hwnd, &rect );
	
			mainwindow.hwndLblFolder	= CreateWindow(_T("STATIC"), 
							_T("Folder:"),
							WS_CHILD|WS_VISIBLE|SS_LEFT,
							8,8,rect.right-8,16,
							mainwindow.hwnd,0,hInstance,NULL);		
	
			mainwindow.hwndTxtFolder = CreateWindowEx(WS_EX_CLIENTEDGE,	_T("EDIT"), NULL, ES_AUTOHSCROLL|WS_CHILD|WS_VISIBLE,
				8,8+18,rect.right-21-8-8-4,21,
				mainwindow.hwnd, 0, hInstance, NULL);
	
			if( mainwindow.path_arg != NULL )
			{
				SendMessage( mainwindow.hwndTxtFolder, WM_SETTEXT,0, (LPARAM)mainwindow.path_arg);
			}
	
			mainwindow.hwndCmdFolder = CreateWindow(_T("BUTTON"), _T("..."), WS_CHILD|WS_VISIBLE|BS_TEXT, 
				rect.right-21-8, 8+18,   21,21,
				mainwindow.hwnd,(HMENU)ID_BUTTON_BROWSE_FOLDER,hInstance,NULL);
	
			/*
			mainwindow.hwndChkRecursive = CreateWindow(_T("BUTTON"), _T("Recursive"), BS_AUTOCHECKBOX|WS_CHILD|WS_VISIBLE|BS_TEXT,
				8,8+18+21+4,  rect.right-16 - 96 - 8, 21,
				mainwindow.hwnd,0,hInstance,NULL);
				
			SendMessage(mainwindow.hwndChkRecursive,		BM_SETCHECK, (WPARAM)TRUE,	0);
			*/	
			mainwindow.hwndCmdDoIt = CreateWindow(_T("BUTTON"), _T("Set date to newest file"), WS_CHILD|WS_VISIBLE|BS_TEXT, 
				rect.right - 160 -8 ,8+18+21+4,  160, 25,
				mainwindow.hwnd,(HMENU)ID_BUTTON_DOIT,hInstance,NULL);				
	
	{
		HFONT hControlFont;
		LOGFONT lfControl;
		memset(&lfControl,0,sizeof(LOGFONT));
		lfControl.lfHeight   = -MulDiv(11, GetDeviceCaps(GetDC(0), LOGPIXELSY), 96);
		lfControl.lfWeight   = FW_NORMAL;
		_tcscpy(lfControl.lfFaceName,_T("Tahoma"));
		// = "Tahoma"; //'Courier'; //'Verdana'; //'MS Sans Serif';

		// Create the font
		hControlFont = CreateFontIndirect(&lfControl);

		// Tell controls to set their fonts
		SendMessage(mainwindow.hwnd,					WM_SETFONT, (WPARAM)hControlFont, 1);

		{		
			SendMessage(mainwindow.hwndLblFolder,		WM_SETFONT, (WPARAM)hControlFont, 1);
			SendMessage(mainwindow.hwndTxtFolder,		WM_SETFONT, (WPARAM)hControlFont, 1);
			SendMessage(mainwindow.hwndCmdFolder,		WM_SETFONT, (WPARAM)hControlFont, 1);
			//SendMessage(mainwindow.hwndChkRecursive,		WM_SETFONT, (WPARAM)hControlFont, 1);
			
			SendMessage(mainwindow.hwndCmdDoIt,		WM_SETFONT, (WPARAM)hControlFont, 1);
		}
	}
				
	ShowWindow(mainwindow.hwnd, nCmdShow);
	UpdateWindow(mainwindow.hwnd);

	{
		MSG Msg;
		while(GetMessage(&Msg, NULL, 0, 0) > 0)
		{
			TranslateMessage(&Msg);
			DispatchMessage(&Msg);
		}
	}
	return 0;
}

