#ifndef MADAH_GAME_H_
#define MADAH_GAME_H_

#include <SDL.h>

// #include <audiere.h>

#include "maps.h"
#include "player.h"
#include "gamefont.h"

namespace MadahGame
{

const int MAX_KEYSTATES			= SDLK_LAST;
const int MAX_MOUSESTATES		= 4;
const int MAX_PLAYERS			= 6;

const int MAX_MOVINGTILES		= 7;

const int STATE_SCREEN_GAME		= 1;
const int STATE_SCREEN_HELP		= 2;
const int STATE_SCREEN_MENU		= 3;
const int STATE_SCREEN_GAMEEND	= 4;

const int PILE_TILE_RIGHT = 96;

const static char *game_copyright = "MaDah's Treasure Hunting BoardGame! 1.01 (c) 2006 MaDah";

struct mousestate_t
{
	int  button;
	bool moved;
	bool mbdown;
	bool mbpressed;
	int  x,y;
};

struct movingtiles_t
{
	int worldx, worldy;
	int startx,starty,stopx,stopy;

	int movecounter, movecountermax;
	bool isdone, active;
};

struct foundtreasure_t
{
	int count, countmax;
	int tilex,tiley;
	int wsx, wsy;

	int treasure_type;

	boardtile_t * tileptr;
	bool active;

	Player *player;
	int player_index;

	int textx, texty;
	char msg[128];
};

struct menu_t
{
	



};

class Player; // forward

class Game
{
friend class Player;
private:

	GameFont * font;

	// tiles/grafik:
	SDL_Surface *bmp1, *tileselect, *tilebase, 
				*tileplain, *tilequestion,
				*tiletreasure, *tilewater,
				*tileboots, *tilebinoculars, 
				*tilespider, *tilebear, *tilecrow,
				*tileroad[MAX_MOVINGTILES],

				*tilegrass, *tileplayer, *tiledot;

	Uint32 graycolor;

	bool should_quit;
	int screen_state;
	int help_prev_state;

	int framecounter;
	bool game_isdone;

	movingtiles_t movingtiles[MAX_MOVINGTILES];
	int movingtilescount;

	foundtreasure_t	foundtreasure;	

	BoardMap *map;

	bool keydown[MAX_KEYSTATES];
	bool keypressed[MAX_KEYSTATES];
	mousestate_t mousestate[MAX_MOUSESTATES];

	Player *player[MAX_PLAYERS];
	Player *selected_player, *active_player;
	int current_player;

	void InitStates();
	void ResetStates();

	// sound
	// audiere::AudioDevicePtr		device;
	// audiere::OutputStreamPtr		sound;

	// game logic:
	void CheckPlayerMove( Player *p );
	void DoGameLogic();

	void AddNewTileAt( int x, int y, int index );
	void AddPlayerFoundTreasure( Player *p, int px, int py, boardtile_t *tile);

	bool IsBlockedTile(const int x, const int y);

	// Draw screen:
	void Draw_Game		(SDL_Surface *screen, const float alpha);
	void Draw_Menu		(SDL_Surface *screen, const float alpha);
	void Draw_GameEnd	(SDL_Surface *screen, const float alpha);
	void Draw_Help		(SDL_Surface *screen, const float alpha);

	// Update Game logic:
	void Update_Game	(const float dt);
	void Update_Menu	(const float dt);
	void Update_GameEnd	(const float dt);
	void Update_Help	(const float dt);

	void CheckGameOver();

public:
	
	bool ShouldQuit()	{	return should_quit;	}

	// Redraw entire screen:
	void Draw(SDL_Surface *screen, const float alpha);

	// Update game logic:
	void Update(const float dt);

	void InitNewGame();

	// Input handling:  SDLinput -> game wrapper
	void KeyDown		(SDL_keysym *key);
	void KeyUp			(SDL_keysym *key);
	void MouseMove		(SDL_MouseMotionEvent *motion);
	void MouseDown		(SDL_MouseButtonEvent *button);
	void MouseUp		(SDL_MouseButtonEvent *button);

	// constructor/destructor
	Game();
	~Game();
};

// misc functions:

// Load image using physfs and converts into correct displayformat
SDL_Surface * LoadImage(const char *filename, const bool colorkey, const Uint32 key);


};

#endif
