#include <SDL.h>


#include "game.h"
#include "maps.h"
#include "player.h"
#include "gamefont.h"

namespace MadahGame
{

void Game::Draw_Help(SDL_Surface *screen, const float alpha)
{
	SDL_Rect rect;

	// HOWTO
	{
		SDL_Surface *legendtiles[]  = {tileplain, tileroad[6], tilegrass,  tilewater, 
										tiletreasure, tileboots, tilebinoculars, tilespider, tilebear, tilecrow,
										NULL};
		SDL_Surface *legendtiles2[] = {NULL, tileplain, NULL, NULL, 
										tileplain, tileplain, tileplain, tileplain, tileplain,
										tileplain, NULL, NULL, NULL, NULL, 
										};
		const char *names[]			= {"Plain", "Road\n +1 Walk points", "Forest\n -1 Explore points", "Water\n Impassable", "Treasure\n Collect as much of\n these as possible\n to win the game!", 
										"Boots\n +1 Walk points",
										"Binoculars\n +1 Explore points",
										"Spider\n If you're bitten\n you must pass one turn!",
										"Hungry Bear\n Eats your boots\n and binoculars!",
										"Crow\n Steals one treasure!",
											NULL,NULL,NULL,NULL,NULL,NULL,NULL
											};
		const bool tilebreak[]		=	{false,false,false,true,false,false,false,false,false,false,false};

		//font->PrintText(screen, 400-32, 224-16, "Terrain / Items:");
		int px=0,py=0;

		for(int i=0; legendtiles[i]; i++)
		{
			rect.x	= (Sint16)(32 + px*320);
			rect.y	= (Sint16)(64 + 72*py);

			if( legendtiles2[i] )
			{
				SDL_BlitSurface( legendtiles2[i], NULL, screen, &rect );
			}
			SDL_BlitSurface( legendtiles[i], NULL, screen, &rect );

			font->PrintText(screen, rect.x+37*2, rect.y, names[i]);

			py++;
			if( tilebreak[i] )
			{
				px++; py = 0;
			}
		}
	}

	font->PrintText(screen, 8,8, "Terrain / Items:");
	font->PrintText(screen, 0,600-16, game_copyright);
}

void Game::Update_Help(const float dt)
{
	if( this->keypressed[SDLK_ESCAPE] || this->keypressed[SDLK_h] || this->keypressed[SDLK_F1] ||
		this->mousestate[1].mbpressed || this->mousestate[2].mbpressed)
	{
		this->screen_state = this->help_prev_state;
		if( this->screen_state == STATE_SCREEN_HELP )
		{
			this->screen_state = STATE_SCREEN_MENU;
		}
	}

	framecounter++;	
	framecounter &= 0x3FFFFFFF;

	// Clear keyboard/mouse
	ResetStates();
}


};
