#include <math.h>

#include <SDL.h>

#include "math_consts.h"

#include "game.h"
#include "maps.h"
#include "player.h"
#include "gamefont.h"

namespace MadahGame
{

void Game::Draw_Menu(SDL_Surface *screen, const float alpha)
{
	const char *menustr[] = {"Off", "Human", "Computer"};
	const int menuleft[] = {-20,-32,-48};

	SDL_Rect rect;

	for(int i=0; i<3; i++)
	{
		font->PrintText(screen, 48+i*96 + menuleft[i]+48,			32+32, menustr[i] );
	}

	for(int i=0; i<=MAX_PLAYERS; i++)
	{
		rect.h = 2;
		rect.w = 96*3;
		rect.x = 48 ;
		rect.y = (Sint16)(32+48 + 64*i);
		SDL_FillRect(screen, &rect, graycolor);
	}

	for(int i=0; i<=3; i++)
	{
		rect.h = MAX_PLAYERS*64+2;
		rect.w = 2;
		rect.x = (Sint16)(48 + 96*i);
		rect.y = 32+48;
		SDL_FillRect(screen, &rect, graycolor);
	}



	/*
	for(int i=0; i<MAX_PLAYERS; i++)
	{
		for(int j=0; j<3; j++)
		{
			rect.x = 48 + j * 96 +11 ;
			rect.y = 32+48 + i *64;

			SDL_BlitSurface( tilebase, NULL, screen, &rect );
		}
	}
	*/

	for(int i=0; i<MAX_PLAYERS; i++)
	{
		if( player[i]->active )
		{
			if( player[i]->human ) player[i]->menualt = 1;
			else player[i]->menualt=2;
		}
		else player[i]->menualt= 0;

		rect.x = (Sint16)(48 + player[i]->menualt * 96 +11);
		rect.y = (Sint16)(32+48 + i *64);

		SDL_BlitSurface( player[i]->gfx, NULL, screen, &rect );
	}

	{
		int tx = (mousestate[0].x-48);
		int ty = (mousestate[0].y-(48+32));

		if( (tx>=0) && (ty>=0) )
		{
			tx /= 96;
			ty /= 64;
			if( (tx>=0) && (ty>=0) && (tx<3) && (ty<MAX_PLAYERS) )
			{
				int px = tx * 96 + 48 + 96/2;
				int py = ty * 64 + 48+32 + 64/2;

				px -= tiledot->w/2;
				py -= tiledot->h/2;

				// Dots at center
				{
					const int numdots = 12;
					for(int i=0; i<numdots; i++)
					{
						float t = ( ((float)i + ((float)(framecounter&0x0f)+alpha)/16.0f) / (float)numdots ) * 2.0f * (float)MATH_PI;

						rect.x	= (Sint16)(px + (int)((float)40.0f * cosf(t)));
						rect.y	= (Sint16)(py + (int)((float)32.0f * sinf(t)));

						SDL_BlitSurface( tiledot, NULL, screen, &rect );
					}
				}

				// Dots from player
				if( player[ty]->menualt  != tx )
				{
					// i = ty;

					int dx = player[ty]->menualt * 96 + 48 + 96/2;
					int dy = ty * 64 + 48+32 + 64/2;

					dx -= tiledot->w/2;
					dy -= tiledot->h/2;

					const int numdots = 6;
					for(int i=0; i<numdots; i++)
					{
						float t = ( ((float)i + ((float)(framecounter&0x03)+alpha)/4.0f) / (float)numdots );

						rect.x	= (Sint16)(dx + (int)(t*(float)(px - dx)));
						rect.y	= (Sint16)(dy + (int)(t*(float)(py - dy) + 8.0f*cosf(t*2.0f*(float)MATH_PI)));

						SDL_BlitSurface( tiledot, NULL, screen, &rect );
					}
				}


				font->PrintText(screen, mousestate[0].x + menuleft[tx], mousestate[0].y+16, menustr[tx]);
			}
		}
	}

	{
		const char *mainmenu[] = {"BEGIN GAME!", "HELP", "QUIT"};

		for(int i=0; i<3; i++)
		{
			font->PrintText(screen, 480, 96 + 48*i, mainmenu[i] );
		}

		int tx = (mousestate[0].x-480);
		int ty = (mousestate[0].y-96);

		if( (tx>=0) && (ty>=0) )
		{
			tx /= 128;
			ty /= 48;
			if( (tx==0) && (ty>=0) && (ty<3) )
			{
				int px = tx * 128 + 480 + 128/2;
				int py = ty * 48 + 96 + 8;

				px -= tiledot->w/2;
				py -= tiledot->h/2;

				// Dots at center
				{
					const int numdots = 24;
					for(int i=0; i<numdots; i++)
					{
						float t = ( ((float)i + ((float)(framecounter&0x07)+alpha)/8.0f) / (float)numdots ) * 2.0f * (float)MATH_PI;

						rect.x	= (Sint16)(px + (int)((float)80.0f * cosf(t)));
						rect.y	= (Sint16)(py + (int)((float)24.0f * sinf(t)));

						SDL_BlitSurface( tiledot, NULL, screen, &rect );
					}
				}
			}
		}
	}

	font->PrintText(screen, 8,8, "Player Setup:");
	font->PrintText(screen, 0,600-16, game_copyright);
}

void Game::Update_Menu(const float dt)
{
	if( mousestate[1].mbpressed )
	{
		int tx = (mousestate[1].x-48);
		int ty = (mousestate[1].y-(48+32));

		if( (tx>=0) && (ty>=0) )
		{
			tx /= 96;
			ty /= 64;
			if( (tx>=0) && (ty>=0) && (tx<3) && (ty<MAX_PLAYERS) )
			{
				player[ty]->menualt = tx;
				switch( player[ty]->menualt )
				{
				case 0:	player[ty]->active = false;
						break;
				case 1:	player[ty]->active	= true;
						player[ty]->human	= true;
						break;
				case 2:	player[ty]->active = true;
						player[ty]->human	= false;
						break;
				}

			}
		}

		tx = (mousestate[1].x-480);
		ty = (mousestate[1].y-96);

		if( (tx>=0) && (ty>=0) )
		{
			tx /= 128;
			ty /= 48;

			if( (tx>=0) && (ty>=0) && (tx<1) && (ty<3) )
			{
				switch( ty )
				{
				case 0:	// New Game
						screen_state = STATE_SCREEN_GAME;
						this->InitNewGame();
						break;
				case 1:	// Help
						this->help_prev_state = STATE_SCREEN_MENU;
						screen_state = STATE_SCREEN_HELP;
						break;
				case 2: // Quit
						this->should_quit = true;
						break;
				}
			}
		}
	}

	if( this->keypressed[SDLK_ESCAPE] )
	{
		this->should_quit = true;
	}

	if( this->keypressed[SDLK_h] || this->keypressed[SDLK_F1] )
	{
		this->help_prev_state = STATE_SCREEN_MENU;
		screen_state = STATE_SCREEN_HELP;
	}

	framecounter++;
	framecounter &= 0x3FFFFFFF;

	// Clear keyboard/mouse
	ResetStates();
}




};
