#include <stdlib.h>
#include <limits.h>
#include <tchar.h>
#include <time.h>

#include <SDL.h>

#include "game.h"
#include "mt19937ar.h"



void GameLoop(SDL_Surface * screen, const Uint32 dt)
{
	Uint32 time_accumulator = 0, time_current=0, time_new=0, time_delta=0;

	// 80 ms => 12.5 fps
	// 40 ms => 25 fps
	// 20 ms => 50 fps osv
	//const Uint32 dt = 80;

	const float dt_f = (float)dt;
	const float dt_inv = 1.0f / dt_f;

	SDL_Rect rect;
	SDL_Event event;
	int should_quit = 0;

	MadahGame::Game *game = new MadahGame::Game();

	event.type = 0;

	while( should_quit == 0 )
	{
		while ( SDL_PollEvent(&event) )
		{
			if ( (event.type == SDL_QUIT)  || (game->ShouldQuit()) ) //|| ((event.type == SDL_KEYDOWN) && (event.key.keysym.sym == SDLK_ESCAPE)) )
			{
				should_quit = 1;
			}

			if( event.type == SDL_KEYDOWN )
			{
				if( event.key.keysym.sym == SDLK_F11 )
				{
					SDL_SaveBMP( screen, "screenshot.bmp" );
					//screen_buff->L
				}
			}

			switch( event.type )
			{
			case SDL_KEYDOWN:			game->KeyDown	( &event.key.keysym );	break;
			case SDL_KEYUP:				game->KeyUp		( &event.key.keysym );	break;

			case SDL_MOUSEMOTION:		game->MouseMove	( &event.motion );		break;
			case SDL_MOUSEBUTTONDOWN:	game->MouseDown	( &event.button );		break;
			case SDL_MOUSEBUTTONUP:		game->MouseUp	( &event.button );		break;
			}
		}

		//	Run game logic at constanst fps:
		time_current	= time_new;
		time_new		= SDL_GetTicks();
		time_delta		= (time_new - time_current);

		// Hgst 2 sekunders lag.
		// Fr annars om man t ex alt-tabbat i 10 minuter
		// kommer spelet frska "hinna ikapp"
		if( time_delta > 2000 ) time_delta = 2000;

		time_accumulator += time_delta;
		while( time_accumulator >= dt )
		{
			game->Update( dt_f );
			time_accumulator -= dt;
		}

		// rita upp skrmen
		// interpolera mellan aktuell och fregende frame (position etc)
		// p detta stt fr man garanterat mjuk grafik
		// och spelet uppfrs sig exakt likadant oavsett hastighet
		const float framealpha = (float)time_accumulator * dt_inv;

		// ********************
		rect.w = (Uint16)screen->w;
		rect.h = (Uint16)screen->h;
		rect.x = 0;
		rect.y = 0;
		SDL_FillRect(screen, &rect, 0);

		game->Draw( screen, framealpha );

		SDL_Flip(screen);
		SDL_Delay(5);
 	}
	delete game;
}

int main( int argc, char* argv[] )
{
    printf("main()\n");

	init_genrand( (unsigned long)time(NULL) );

    // Initialize the SDL library
    if ( SDL_Init(SDL_INIT_VIDEO) < 0 )
	{
		printf("SDL_Init() failed!\n");
        // Clean up on exit
        SDL_Quit();
	}

	// stlla in width/height osv frn args

	int width	= 800;
	int height	= 600;
	int bits	= 0;
	Uint32 dt		= 80;
	Uint32 flags	= SDL_DOUBLEBUF | SDL_HWSURFACE;

	for(int i=1; i<argc; i++)
	{
		if( argv[i][0] == '-' )
		{
			switch( argv[i][1] )
			{
			case 'w':	i++; width	= atoi(argv[i]);	break;
			case 'h':	i++; height = atoi(argv[i]);	break;
			case 'b':	i++; bits	= atoi(argv[i]);	break;

			case 'f':	flags	|= SDL_FULLSCREEN;	break;
			case 'd':	i++; dt		= atoi(argv[i]);	break;
			}
		}
	}

	/* Get available fullscreen/hardware modes */
	SDL_Rect ** modes = SDL_ListModes(NULL, flags);

	/* Check is there are any modes available */
	if(modes == (SDL_Rect **)0)
	{
		printf("No modes available!\n");
		exit(-1);
	}

	/* Check if our resolution is restricted */
	if(modes == (SDL_Rect **)-1)
	{
		printf("All resolutions available.\n");
	}
	else
	{
		/* Print valid modes */
		int i;
		printf("Available Modes:\n");
		for(i=0;modes[i];++i)
		{
			printf("  %d x %d\n", modes[i]->w, modes[i]->h);
		}
	}

    SDL_Surface * screen = SDL_SetVideoMode(width,height,bits,flags);

	if ( screen == NULL )
	{
		printf("SDL_SetVideoMode() failed!\n");
        SDL_Quit();
	}

	SDL_WM_SetCaption( MadahGame::game_copyright, NULL );

	if( dt < 1 ) dt = 1;
	GameLoop(screen, (const Uint32)dt);

	SDL_Quit();
	return 0;
}
