#include <stdlib.h>
#include <string.h>

#include "maps.h"

namespace MadahGame
{

	void BoardMap::SetBoardRect(int x1,int y1,int x2,int y2)
	{
		boardx1 = x1;
		boardy1 = y1;
		boardx2 = x2;
		boardy2 = y2;
		AutoSizeBoard();
	}

	void BoardMap::AutoSizeBoard()
	{

	}

	void BoardMap::SetHexRadiusHeight(int r, int h)
	{
		hexradius = r;
		if( h <= 0 )
		{
			// sqrt(0.75) = 0.86602540...
			hexheight = (int)(0.5f + 0.86602540f * (float)hexradius);
		}
		else
		{
			hexheight = h;
		}
	}

	void BoardMap::SetScreenSize(int w,int h)
	{
		screenwidth		= w;
		screenheight	= h;

		tiletop = (screenheight - ((height*2+1)*hexheight)) / 2;
		tileleft =tiletop;
	}

	void BoardMap::AllocMap(int w,int h)
	{
		if(tiles) free(tiles);

		tiles = (boardtile_t *)calloc( w*h, sizeof(boardtile_t) );

		width  = w;
		height = h;
	}

	int BoardMap::GetNearbyTiles(const int cx, const int cy, int *tx, int *ty)
	{
		// sanity check:
		if( (cx<0) || (cy<0) || (cx>=width) || (cy>=height) )	return 0;

		// positions to nearby tiles:
		const int evendir[] = {
			-1,-1,		0,-1,		1,-1,
			-1,0,					1,0,
						0,1};
		const int oddir[] = {
   						0,-1,
			-1,0,					1,0,
			-1,1,		0,1,		1,1};

		const int *dirptr = &oddir[0];

		int count=0;

		if( (cx & 1)==0 )	dirptr = &evendir[0];

		for(int d=0; d<6; d++)
		{
			int nx = cx + dirptr[ 2*d ];
			int ny = cy + dirptr[ 2*d+1 ];

			if( (nx>=0) && (ny>=0) && (nx<width) && (ny<height) )
			{
				if( tiles[ny*width+nx].disabled == false )
				{
					*tx++ = nx;
					*ty++ = ny;
					count++;
				}
			}
		}

		return count;
	}

	bool BoardMap::IsBlockedTile(const int dstx, const int dsty)
	{
		// Check terrain
		if( (dstx>=0) && (dsty>=0) && (dstx<width) && (dsty<height) )
		{
			boardtile_t *tile = &tiles[dsty*width+dstx];
			if( (tile->disabled==false) && (tile->type != 2) )
			{
				return false;
			}
		}
		return true;
	}

	int BoardMap::GetDistance(const int srcx, const int srcy, const int dstx, const int dsty)
	{
		if( (srcx==dstx) && (srcy==dsty) )
		{
			return 0;
		}

		int tx[6], ty[6];
		int count = GetNearbyTiles( srcx, srcy, &tx[0], &ty[0] );

		for(int i=0; i<count; i++)
		{
			if( (dstx==tx[i]) && (dsty==ty[i]) )
			{
				return 1;
			}
		}

		return 999;
	}

	void BoardMap::UpdateRoadMask()
	{
		// clockwise order:
		const int evendir[] = {0,-1,	1,-1,	1,0,	0,1,	-1,0,	-1,-1	};
		const int oddir[]	= {0,-1,	1,0,	1,1,	0,1,	-1,1,	-1,0	};

		// clear mask:
		const int len = width*height;
		int x,y,i;
		boardtile_t *ptr = tiles;

		for(i=0; i<len; i++)	tiles[i].roadmask = 0;

		for(y=0; y<height; y++)
		{
			for(x=0; x<width; x++)
			{
				if( ptr->has_road )
				{
					const int *dirptr = &oddir[0];
					if( (x & 1)==0 )	dirptr = &evendir[0];

					for(i=0; i<6; i++)
					{
						int nx = x + dirptr[2*i];
						int ny = y + dirptr[2*i+1];

						if( (nx>=0) && (ny>=0) && (nx<width) && (ny<height) )
						{
							boardtile_t *tile = &tiles[ ny * width + nx ];
							if( tile->has_road )
							{
								ptr->roadmask |= (1 << i);
							}
						}
					}
				}
				ptr++;
			}
		}

	}

	void BoardMap::ScreenToWorldCoord(const int sx, const int sy, int *wx, int *wy)
	{
		*wx	= (sx - tileleft - hexradius/4) / (3*hexradius/2);
		*wy = (sy - tiletop  - ((*wx)&1)*hexheight) / (2*hexheight);
	}

	void BoardMap::WorldToScreenCoord(const int wx, const int wy, int *sx, int *sy)
	{
		*sx	= tileleft + 3*wx*hexradius / 2;
		*sy = tiletop +  (2*wy + (wx&1))*hexheight ;
	}

	void BoardMap::WorldToScreenCoordCenter(const int wx, const int wy, int *sx, int *sy)
	{
		*sx	= tileleft + 3*wx*hexradius / 2 + hexradius;
		*sy = tiletop +  (2*wy + (wx&1) + 1)*hexheight ;
	}

	void BoardMap::ClearMap()
	{
		size_t size = width * height * sizeof(boardtile_t);
		memset( &tiles[0], 0, size );

	}

	BoardMap::BoardMap()
		:width(0),height(0),hexradius(0),hexheight(0),tiles(NULL)
	{


	}

	BoardMap::~BoardMap()
	{
		if(tiles) free(tiles);

	}


};
