#ifndef MADAH_GAME_MAPS_H
#define MADAH_GAME_MAPS_H

namespace MadahGame
{

// forward
class Game;	

struct boardtile_t
{
	int type;
	/*	
		bitmask:
	
		1	Road
		2	River
		4	
		8	
	*/
	bool explored;
	bool has_treasure;
	bool treasure_hidden;
	bool has_road;
	int roadmask;

	bool disabled;
	int treasure_type;
};

class BoardMap
{
friend class Game;
private:

	int width,height;
	
	// appearance & position on screen:
	// also for mouse screen<->world coordinates
	int hexradius,hexheight,tileleft,tiletop;
	// rect to place the board on screen:
	int screenwidth,screenheight;
	int boardx1,boardy1,boardx2,boardy2;

	boardtile_t	*tiles;

	void AutoSizeBoard();

public:

	boardtile_t	*GetTiles()	{	return tiles;	};

	int GetWidth()			{	return width;	}
	int GetHeight()			{	return height;	}

	void ClearMap();

	void SetScreenSize(int w,int h);
	
	void SetHexRadiusHeight(int r, int h);
	void SetBoardRect(int x1,int y1,int x2,int y2);

	int GetNearbyTiles(const int cx, const int cy, int *tx, int *ty);

	bool IsBlockedTile(const int dstx, const int dsty);
	int GetDistance(const int srcx, const int srcy, const int dstx, const int dsty);

	void UpdateRoadMask();

	void ScreenToWorldCoord(const int sx, const int sy, int *wx, int *wy);
	void WorldToScreenCoord(const int wx, const int wy, int *sx, int *sy);
	void WorldToScreenCoordCenter(const int wx, const int wy, int *sx, int *sy);

	void AllocMap(int w,int h);

	BoardMap();
	~BoardMap();
};

};

#endif
