#ifndef MADAH_MATH_CONSTS_H
#define MADAH_MATH_CONSTS_H

#ifdef  __cplusplus
extern "C" {
#endif

/*

1 - E - natural log - Euler's number - 2.71828182845905
2 - LN2 - natural log of 2 - 0.69314718055994528623
3 - LN10 - natural log of 10 - 2.3025850929940459011
4 - LOG2E - base 2 of natural log (E) - 1.442695040888963387
5 - LOG10E - base 10 of natural log (E) - 0.43429448190325181667
6 - PI - ratio of circumference to diameter of a circle - 3.14159265358979
7 - SQRT1_2 - squareroot of 1/2 - 0.707106781186
8 - SQRT2 - squareroot of 2 - 1.414213562373

1 - DEG2RAD - convert degrees to radians - 0.0174532925199433
2 - RAD2DEG - convert radians to degrees - 57.2957795130823
3 - PHI - the golden mean - 1.61803398874989
4 - LAMBDA - Euler-Mascheroni constant - .5772156649

*/

#define MATH_E			(2.718281828459045235360287471352662497757247093699959574966967628)
#define MATH_LN2		(0.6931471805599453094172321214581765680755001343602552541206800095)
#define MATH_LN10		(2.302585092994045684017991454684364207601101488628772976033327901)
#define MATH_LOG2E		(1.442695040888963407359924681001892137426645954152985934135449407)
#define MATH_LOG10E		(0.4342944819032518276511289189166050822943970058036665661144537832)
#define MATH_PI			(3.141592653589793238462643383279502884197169399375105820974944592)
#define MATH_SQRT1_2	(0.707106781186547524400844362104849039284835937688474036588339869)
#define MATH_SQRT2		(1.414213562373095048801688724209698078569671875376948073176679738)

#define MATH_DEG2RAD	(0.0174532925199432957692369076848861271344287188854172545609719144)
#define MATH_RAD2DEG	(57.29577951308232087679815481410517033240547246656432154916024386)

// (1 + SQRT(5))/2
#define MATH_PHI		(1.618033988749894848204586834365638117720309179805762862135448623)

#ifdef  __cplusplus
}   /* ... extern "C" */
#endif

#endif
