#include <math.h>

#include <SDL.h>

#include "math_consts.h"

#include "game.h"
#include "maps.h"
#include "player.h"

#include "mt19937ar.h"

namespace MadahGame
{

	void Player::Hotspot(const int tx, const int ty)
	{
		nexttargetx		= tx; 
		nexttargety		= ty;
		hasnexttarget	= true;
	}

	void Player::HotspotMove(const int tx, const int ty)
	{
		nexttargettype = 0;
		Hotspot(tx,ty);
	}

	void Player::HotspotExplore(const int tx, const int ty)
	{
		nexttargettype = 1;
		Hotspot(tx,ty);
	}


	void Player::Hotspot(const int tx, const int ty, Player *otherplayer)
	{

	}

	void Player::AI_Think()
	{
		// just move to the nearest free position
		int tx[6], ty[6];
		int count = map->GetNearbyTiles(x,y,&tx[0],&ty[0]);

		if( count >0 )
		{
			bool shouldmove = true;
			nexttargettype = 0;
			// explore first
			if( explorepointsleft >0 )
			{
				boardtile_t *tiles = map->GetTiles();
				int list[6];
				int listcount=0;
				for(int i=0; i<count; i++)
				{
					boardtile_t *tile = &tiles[ty[i]*map->GetWidth()+tx[i]];
					if( tile->explored== false )
					{
						list[listcount] = i;
						listcount++;
					}
				}
				// random from unexplored list:
				int r;
				
				if( listcount > 0 )
				{
					r = genrand_int31() % listcount;

					nexttargetx		= tx[list[r]]; 
					nexttargety		= ty[list[r]];
					hasnexttarget	= true;
					nexttargettype = 1;
					shouldmove = false;
				}
			}

			if( shouldmove ) // move in random direction
			{
				if( (movepointsleft>0) )
				{
					boardtile_t *tiles = map->GetTiles();
					int list[6];
					int listcount=0;
					int bestindex=-1;
					int bestscore=-1;
					int score=0;

					for(int i=0; i<count; i++)
					{
						boardtile_t *tile = &tiles[ty[i]*map->GetWidth()+tx[i]];
						if( (tile->explored) && (game->IsBlockedTile(tx[i], ty[i]) == false) )
						{
							score=0;
							// hindra s att AI:n inte bara gr fram och tillbaka
							if( (tx[i] == lastx) && (ty[i]==lasty) )	score -= 5;

							// ge treasures hg pong s att AI:N skert gr dit
							if( tile->has_road )		score += 2;
							if( tile->type == 0 )		score += 2;
							if( tile->has_treasure )	score += 200;

							// check surrounings
							{
								int tx2[6],ty2[6];
								int count2 = map->GetNearbyTiles(tx[i],ty[i],&tx2[0],&ty2[0]);

								for(int j=0; j<count2; j++)
								{
									boardtile_t *tile2 = &tiles[ty2[j]*map->GetWidth()+tx2[j]];
									if( tile2->explored == false )	score += 15;
									if( tile2->has_treasure )		score += 45;
									if( tile2->has_road )			score += 1;
									if( tile2->type == 0 )			score += 1;
								}
							}

							score += genrand_int31() & 0x03;

							if( score > bestscore )
							{
								bestscore = score;
								bestindex = i;
							}

							list[listcount] = i;
							listcount++;
						}
					}
					// random from unexplored list:
					int r;
					
					if( bestindex >= 0 )
					{
						r = bestindex; //genrand_int31() % listcount;

						nexttargetx		= tx[bestindex]; 
						nexttargety		= ty[bestindex];
						hasnexttarget	= true;
						nexttargettype = 0;
					}
					else
					{
						pass = true;
					}
				}
				else
				{
					pass = true;
				}
			}

		}
		else
		{
			pass = true;
		}

	}

	void Player::Update(const float dt)
	{
		ready=false;
		switch( state )
		{	
		case 0:	// Idle
		
			if( ((movepointsleft<=0) && (explorepointsleft<=0)) || (pass) )
			{
				isdone = true;
				boardtile_t *tile = map->GetTiles();
				tile = &tile[y*map->GetWidth()+x];

				movepointsleft	  = 1;
				explorepointsleft = 2;

				if( tile->has_road )
				{
					movepointsleft++;
				}

				if( tile->type == 1)	// forest
				{
					explorepointsleft--;
				}

				if( has_boots )			movepointsleft++;
				if( has_binoculars )	explorepointsleft++;
				if( has_spider )
				{
					movepointsleft = 0;
					explorepointsleft = 0;
					has_spider = false;
				}

				break;
			}

			ready= true;
			if( human == false ) AI_Think();
			if( hasnexttarget )	
			{
				if( (nexttargettype==1) && (explorepointsleft>0) )
				{
					hastarget		= true;
					targetx			= nexttargetx;
					targety			= nexttargety;
					hasnexttarget	= false;
					movecounter		= 0;
					movecountermax	= 8;
					state = 2;
					game->AddNewTileAt(targetx,targety,0);
				}
				else if( (nexttargettype==0) && (movepointsleft>0) )
				{
					hastarget		= true;
					targetx			= nexttargetx;
					targety			= nexttargety;
					hasnexttarget	= false;
					movecounter		= 0;
					movecountermax	= 8;
					state = 1;
				}
				hasnexttarget	= false;
			}
			break;

		case 1: // On the Move
			movecounter++;
			if( movecounter >= movecountermax )
			{
				hastarget = false;
				lastx = x;
				lasty = y;
				x = targetx;
				y = targety;
				state = 0;
				movepointsleft--;
				game->CheckPlayerMove(this);
				//isdone = true;
			}
			break;

		case 2:	// Waiting to explore
			movecounter++;
			if( movecounter >= movecountermax )
			{
				hastarget = false;
				state = 0;
				explorepointsleft--;
				//isdone = true;
			}
			break;

		case 3:	// Idle-Wait
			movecounter++;
			if( movecounter >= movecountermax )
			{
				state = 0;
				//isdone = true;
			}
			break;
		}

		framecounter++;
	}

	void Player::Draw(SDL_Surface *screen, const float alpha)
	{
		int x1,y1;
		map->WorldToScreenCoord(x,y,&x1,&y1);	

		SDL_Rect rect;
		rect.x = (Sint16)x1;
		rect.y = (Sint16)y1;
		
		if( (state == 1) && (movecounter>0) )
		{
			int x2,y2;
			float t = ((float)movecounter + alpha)/(float)movecountermax;

			float t2 = (float)(t+(framecounter&0x0f)/16.0f);
			float u  = 4.0f*cosf((t2)*4.0f*(float)MATH_PI);

			map->WorldToScreenCoord(targetx,targety,&x2,&y2);

			rect.x = (Sint16)((int)(t * (x2 - x1)) + x1);
			rect.y = (Sint16)((int)(t * (y2 - y1) + y1 + u));
		}

		rect.y -= ((Sint16)gfx->h/3);
		SDL_BlitSurface( gfx, NULL, screen, &rect );
	}

	void Player::Reset()
	{
		has_boots		= false;
		has_binoculars	= false;
		has_spider		= false;
		treasurecount	= 0;

		lastx = -1;
		lasty = -1;
		hastarget = false;
		hasnexttarget = false;
		movecounter=0;
		movecountermax=0;

		framecounter = 0;
		selected = false;

		movepointsleft = 0;
		explorepointsleft = 0;
		isdone = false;

		state = 0;
		//human = false;
		//active = false;
		ready = false;
		x = 0;
		y = 0;
		score = 0;
	}

	Player::Player()
		:	human(false), active(false), ready(false), x(0), y(0), framecounter(0), selected(false),
			movecounter(0), movecountermax(0), pass(false), lastx(-1), lasty(-1),
			movepointsleft(0), explorepointsleft(0), treasurecount(0),
			state(0), hasnexttarget(false), hastarget(false), isdone(false), gfx(NULL),
			has_boots(false), has_binoculars(false), has_spider(false), score(0)
	{

	}

	Player::~Player()
	{

	}	





};
