#ifndef MADAH_GAME_PLAYER_H
#define MADAH_GAME_PLAYER_H

#include <SDL.h>

namespace MadahGame
{

// foward
class Game;	
class BoardMap;
class Player;	


class Player
{
friend class Game;
private:

	bool has_boots, has_binoculars, has_spider;

	int menualt;
	int index, score;

	BoardMap *map;
	Game *game;

	SDL_Surface *gfx;

	bool human, active, ready, selected, isdone, pass;

	int lastx, lasty, x,y,state, laststate;

	int treasurecount;

	int movepointsleft, explorepointsleft;

	int targetx, targety, hastarget;
	int movecounter, movecountermax;

	int nexttargetx, nexttargety, hasnexttarget;
	int nexttargettype;

	int framecounter;

	void AI_Think();

public:

	void Hotspot(const int tx, const int ty);
	void HotspotMove(const int tx, const int ty);
	void HotspotExplore(const int tx, const int ty);
	void Hotspot(const int tx, const int ty, Player *otherplayer);

	void Update(const float dt);
	void Draw(SDL_Surface *screen, const float alpha);

	void Reset();

	Player();
	~Player();

};

};

#endif
